/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.block;

import dev.felnull.imp.block.IMPBaseEntityBlock;
import dev.felnull.imp.block.IMPBlockStateProperties;
import dev.felnull.imp.blockentity.BoomboxBlockEntity;
import dev.felnull.imp.blockentity.IMPBlockEntities;
import dev.felnull.imp.item.BoomboxItem;
import dev.felnull.otyacraftengine.util.OEVoxelShapeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BoomboxBlock
extends IMPBaseEntityBlock {
    private static final OEVoxelShapeUtil.DirectionVoxelShapes SHAPE = OEVoxelShapeUtil.makeAllDirection((VoxelShape)OEVoxelShapeUtil.getShapeFromResource((ResourceLocation)new ResourceLocation("iammusicplayer", "boombox"), BoomboxBlock.class));
    private static final OEVoxelShapeUtil.DirectionVoxelShapes SHAPE_NO_RAISED = OEVoxelShapeUtil.makeAllDirection((VoxelShape)OEVoxelShapeUtil.getShapeFromResource((ResourceLocation)new ResourceLocation("iammusicplayer", "boombox_no_raised"), BoomboxBlock.class));
    public static final BooleanProperty RAISED = IMPBlockStateProperties.RAISE;

    protected BoomboxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)RAISED, (Comparable)Boolean.valueOf(true)));
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (player.m_6047_()) {
            BlockEntity be = level.m_7702_(blockPos);
            if (be instanceof BoomboxBlockEntity) {
                BoomboxBlockEntity boombox = (BoomboxBlockEntity)be;
                if (blockHitResult.m_82434_() == Direction.UP) {
                    if (boombox.getBoomboxData().cycleRaisedHandle()) {
                        level.m_5594_(null, blockPos, boombox.getBoomboxData().isLidOpen() ? SoundEvents.f_12056_ : SoundEvents.f_12055_, SoundSource.BLOCKS, 0.5f, 0.4f / (level.m_5822_().nextFloat() * 0.4f + 0.8f));
                        return InteractionResult.m_19078_((boolean)level.m_5776_());
                    }
                } else if (blockHitResult.m_82434_() == blockState.m_61143_((Property)FACING) && boombox.getBoomboxData().cycleLidOpen(level)) {
                    return InteractionResult.m_19078_((boolean)level.m_5776_());
                }
            }
        } else {
            return super.m_6227_(blockState, level, blockPos, player, interactionHand, blockHitResult);
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new BoomboxBlockEntity(blockPos, blockState);
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        OEVoxelShapeUtil.DirectionVoxelShapes shp = (Boolean)blockState.m_61143_((Property)RAISED) != false ? SHAPE : SHAPE_NO_RAISED;
        return shp.getShape((Direction)blockState.m_61143_((Property)FACING));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{RAISED});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return BoomboxBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)IMPBlockEntities.BOOMBOX.get()), BoomboxBlockEntity::tick);
    }

    public ItemStack m_7397_(BlockGetter blockGetter, BlockPos blockPos, BlockState blockState) {
        BlockEntity be = blockGetter.m_7702_(blockPos);
        if (be instanceof BoomboxBlockEntity) {
            BoomboxBlockEntity boomboxBlockEntity = (BoomboxBlockEntity)be;
            return BoomboxItem.createByBE(boomboxBlockEntity, true);
        }
        return super.m_7397_(blockGetter, blockPos, blockState);
    }
}

